<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Dispositivo;
use App\Models\Areas;
use App\Models\TipoDispositivo;
use App\Models\Sucursal;
use App\Models\Estado;
use App\Models\Pantalla;
use App\Models\PcLapCel;

class InventarioVistaController extends Controller
{
    // Muestra la vista principal del inventario con todos los dispositivos y datos relacionados
    public function mostrarinventariovista()
    {
        // Obtiene dispositivos con relaciones para mostrar datos completos
        $dispositivos = Dispositivo::with([
            'tipoDispositivo',
            'area',
            'sucursal',
            'estado',
            'pclapcel',
            'pantalla'
        ])->get();

        // Obtiene listas para los filtros y selects en la vista
        $tiposDispositivo = TipoDispositivo::all();
        $areas = Areas::all();
        $sucursales = Sucursal::all();
        $estados = Estado::all();

        // Retorna la vista con los datos compactados
        return view('inventariovista', compact('dispositivos', 'tiposDispositivo', 'areas', 'sucursales', 'estados'));
    }


    // Realiza búsqueda y filtrado en dispositivos según criterios enviados
    public function buscar(Request $request)
    {
        // Consulta dinámica con filtros condicionales
        $dispositivos = Dispositivo::with(['tipoDispositivo', 'area', 'sucursal', 'estado', 'pclapcel', 'pantalla'])
            ->when($request->filled('busqueda'), function ($query) use ($request) {
                $query->where('NombreDispositivo', 'like', "%{$request->busqueda}%");
            })
            ->when($request->filled('tipo'), function ($query) use ($request) {
                $query->where('IdTipoDispositivo', $request->tipo);
            })
            ->when($request->filled('area'), function ($query) use ($request) {
                $query->where('IdArea', $request->area);
            })
            ->when($request->filled('sucursales'), function ($query) use ($request) {
                $query->where('IdSucursal', $request->sucursales);
            })
            ->when($request->filled('estado'), function ($query) use ($request) {
                $query->where('IdEstado', $request->estado);
            })
            ->get();

        // Datos para selects de filtros
        $tiposDispositivo = TipoDispositivo::all();
        $areas = Areas::all();
        $sucursales = Sucursal::all();
        $estados = Estado::all();

        // Si no hay resultados, regresa con mensaje de error
        if($dispositivos->isEmpty()){
            return redirect()->route('mostrarinventariovista')->with('error', 'Ningún elemento coincide con su búsqueda.');
        }

        // Muestra la vista con resultados filtrados
        return view('inventariovista', compact('dispositivos', 'tiposDispositivo', 'areas', 'sucursales', 'estados'));
    }

}
