<?php

namespace App\Http\Controllers;

use App\Models\Administrador;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    // Muestra el formulario de login al usuario
    public function showLoginForm()
    {
        return view('auth.login'); 
    }

    // Procesa el inicio de sesión con los datos enviados por POST
    public function login(Request $request)
    {
        // Valida que se haya enviado un email válido y una contraseña
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        // Busca al administrador con el correo proporcionado
        $admin = Administrador::where('Correo', $credentials['email'])->first();

        // Verifica que exista el administrador y que la contraseña coincida usando Hash
        if ($admin && Hash::check($credentials['password'], $admin->Contraseña)) {
            // Inicia sesión con el guard 'admin'
            Auth::guard('admin')->login($admin);

            // Regenera la sesión para evitar fijación de sesión
            $request->session()->regenerate();

            // Redirige al inventario después de login exitoso
            return redirect()->route('mostrarinventario');
        }

        // Si falla la autenticación, regresa con un error
        return back()->withErrors([
            'email' => 'Las credenciales proporcionadas no coinciden con nuestros registros.',
        ]);
    }

    // Cierra la sesión del administrador
    public function logout(Request $request)
    {
        // Cierra sesión del guard 'admin'
        Auth::guard('admin')->logout();
        
        // Invalida la sesión actual y regenera el token CSRF para seguridad
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        
        // Redirige a la página de inicio o login
        return redirect('/');
    }
}
