<?php

namespace App\Models;

// Importa clases necesarias de Laravel para autenticación y notificaciones
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

// Clase Administrador que representa a los administradores del sistema
class Administrador extends Authenticatable
{
    // Habilita la funcionalidad de notificaciones para este modelo
    use Notifiable;

    // Define el nombre de la tabla asociada en la base de datos
    protected $table = 'administrador';

    // Define la llave primaria de la tabla
    protected $primaryKey = "IdAdministrador";
    
    // Campos que se pueden asignar de manera masiva
    protected $fillable = [
        'IdAdministrador', 'Nombre', 'Correo', 'Contraseña'  
    ];

    // Campos que se ocultarán cuando el modelo se convierta a array o JSON
    protected $hidden = [
        'Contraseña', 'remember_token', 
    ];

    // Método utilizado por Laravel para obtener la contraseña del usuario al autenticar
    public function getAuthPassword()
    {
        return $this->Contraseña; 
    }
}
