<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

// Modelo Areas que representa la tabla 'areas' en la base de datos
class Areas extends Model
{
    // Nombre de la tabla asociada
    protected $table = 'areas';

    // Llave primaria de la tabla
    protected $primaryKey = 'IdArea';

    // Desactiva timestamps (created_at, updated_at) automáticos de Eloquent
    public $timestamps = false;

    // Relación uno a muchos: un área puede tener varios dispositivos
    public function dispositivos(){
        return $this->hasMany(Dispositivo::class, 'IdArea');
    }

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'IdArea',
        'NombreArea',
    ];
}
