<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

// Modelo Estado que representa la tabla 'estado' en la base de datos
class Estado extends Model
{
    // Nombre de la tabla asociada
    protected $table = 'estado';

    // Llave primaria de la tabla
    protected $primaryKey = 'IdEstado';

    // Desactiva timestamps (created_at, updated_at) automáticos de Eloquent
    public $timestamps = false;

    // Relación uno a muchos: un estado puede estar asociado a varios dispositivos
    public function dispositivos(){
        return $this->hasMany(Dispositivo::class, 'IdEstado');
    }

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'IdEstado',
        'Descripcion',
    ];
}
