<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

// Modelo Pantalla que representa la tabla 'pantalla' en la base de datos
class Pantalla extends Model
{
    // Nombre de la tabla asociada
    protected $table = 'pantalla';

    // Llave primaria de la tabla
    protected $primaryKey = 'IdPantalla';

    // Desactiva timestamps automáticos de Eloquent
    public $timestamps = false;
    
    // Relación uno a muchos: una pantalla puede estar asociada a varios dispositivos
    public function dispositivos(){
        return $this->hasMany(Dispositivo::class, 'IdPantalla');
    }

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'IdPantalla',
        'Pulgadas'
    ];
}
