<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

// Modelo PcLapCel que representa la tabla 'pclapcel' en la base de datos
class PcLapCel extends Model
{
    // Nombre de la tabla asociada
    protected $table = 'pclapcel';

    // Llave primaria de la tabla
    protected $primaryKey = 'IdPcLapCel';

    // Desactiva timestamps automáticos de Eloquent
    public $timestamps = false;

    // Relación uno a muchos: un registro de PcLapCel puede estar asociado a varios dispositivos
    public function dispositivos(){
        return $this->hasMany(Dispositivo::class, 'IdPcLapCel');
    }

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'IdPcLapCel',
        'Memoria',
        'TipoMemoria',
        'Ram',
        'Procesador',
        'SistemaOperativo',
    ];
}
