<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

// Modelo Sucursal que representa la tabla 'sucursal' en la base de datos
class Sucursal extends Model
{
    // Nombre de la tabla asociada
    protected $table = 'sucursal';

    // Llave primaria de la tabla
    protected $primaryKey = 'IdSucursal';

    // Desactiva timestamps automáticos de Eloquent
    public $timestamps = false;

    // Relación uno a muchos: una sucursal puede tener muchos dispositivos asociados
    public function dispositivos(){
        return $this->hasMany(Dispositivo::class, 'IdSucursal');
    }

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'IdSucursal',
        'NombreSucursal',
    ];
}
