<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

// Modelo TipoDispositivo que representa la tabla 'tipodispositivo' en la base de datos
class TipoDispositivo extends Model
{
    // Nombre de la tabla asociada
    protected $table = 'tipodispositivo';

    // Llave primaria de la tabla
    protected $primaryKey = 'IdTipoDispositivo';

    // Desactiva timestamps automáticos de Eloquent
    public $timestamps = false;

    // Relación uno a muchos: un tipo de dispositivo puede tener muchos dispositivos asociados
    public function dispositivos(){
        return $this->hasMany(Dispositivo::class, 'IdTipoDispositivo');
    }

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'IdTipoDispositivo',
        'Tipo',
    ];
}
