// Espera a que el DOM (estructura del HTML) esté completamente cargado antes de ejecutar el código
document.addEventListener('DOMContentLoaded', function() {
    // Obtiene el elemento <select> que contiene el tipo de dispositivo seleccionado por el usuario
    const tipo = document.getElementById('TipoSelect');

    // Obtiene el panel donde se encuentran los campos específicos para computadoras, laptops y celulares
    const panelPcLapCel = document.getElementById('panelPcLapCel');

    // Obtiene el panel donde se encuentran los campos específicos para pantallas
    const panelPantalla = document.getElementById('panelPantalla');

    // Verifica que exista el elemento 'tipo' antes de continuar
    if (tipo) {
        // Agrega un evento al <select> para que detecte cuando el usuario cambie la opción seleccionada
        tipo.addEventListener('change', function() {
            // Convierte el valor seleccionado en número entero
            const tipoSeleccionado = parseInt(this.value);

            // Selecciona todos los inputs y selects dentro del panel de PC/Laptop/Celular
            const camposPcLapCel = panelPcLapCel.querySelectorAll('input, select');

            // Asegura que inicialmente todos los campos del panel PC/Laptop/Celular no sean requeridos
            camposPcLapCel.forEach(campo => campo.required = false);

            // Selecciona todos los inputs y selects dentro del panel de Pantalla
            const camposPantalla = panelPantalla.querySelectorAll('input, select');

            // Asegura que inicialmente todos los campos del panel Pantalla no sean requeridos
            camposPantalla.forEach(campo => campo.required = false);

            // Oculta ambos paneles por defecto al cambiar el tipo
            panelPcLapCel.style.display = 'none';
            panelPantalla.style.display = 'none';

            // Si el tipo seleccionado corresponde a PC (1), Laptop (2) o Celular (7)
            if ([1, 2, 7].includes(tipoSeleccionado)) {
                // Muestra el panel de PC/Laptop/Celular
                panelPcLapCel.style.display = 'block';

                // Hace que todos los campos dentro del panel sean obligatorios
                camposPcLapCel.forEach(campo => campo.required = true);
            } 
            // Si el tipo seleccionado es Pantalla (3)
            else if (tipoSeleccionado === 3) {
                // Muestra el panel de Pantalla
                panelPantalla.style.display = 'block';

                // Hace que todos los campos dentro del panel sean obligatorios
                camposPantalla.forEach(campo => campo.required = true);
            }
        });
    }
});
