﻿// Se obtiene el botón (ícono de líneas) que abre o cierra el menú lateral
const lines = document.getElementById("lines");

// Se selecciona el menú lateral, el cual inicialmente tiene la clase 'aside-hidden' (oculto)
const menu = document.querySelector(".aside-hidden"); 

// Se agrega un evento al botón para mostrar u ocultar el menú lateral al hacer clic
lines.addEventListener("click", () => {
    // Alterna (agrega o quita) la clase 'aside-hidden' que oculta el menú
    menu.classList.toggle("aside-hidden"); 
    
    // Alterna la clase 'aside-visible' que muestra el menú
    menu.classList.toggle("aside-visible"); 
});


// Se ejecuta cuando todo el contenido del DOM ha sido completamente cargado
document.addEventListener('DOMContentLoaded', function() {

    // Se obtiene el botón que limpia los filtros (por ejemplo, de búsqueda en el inventario)
    const btnLimpiar = document.getElementById('btn_limpiarFiltros');

    // Verifica si el botón existe en el DOM
    if (btnLimpiar) {

        // Agrega un evento de clic al botón
        btnLimpiar.addEventListener('click', function() {

            // Obtiene el valor del atributo 'data-url' que contiene la ruta para limpiar los filtros
            const url = btnLimpiar.getAttribute('data-url');

            // Si la URL existe, redirige al navegador a esa ruta
            if (url) {
                window.location.href = url;
            }
        });
    }
});
