<!DOCTYPE html>
<html lang="es">
<head>
    <!-- Configuración básica de la página HTML -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Estilos compartidos con la vista de agregar -->
    <link rel="stylesheet" href="{{ asset('Estilos/actualizar-agregar.css') }}" />
    
    <title>Document</title>
</head>
<body> 
    <!-- Panel principal de edición de dispositivo -->
    <div id="panelEditarDispositivo" class="container-actualizar">
        <h3 class="title-caja">Actualizando dispositivo</h3>

        <div class="box">
            <!-- Formulario para actualizar los datos del dispositivo -->
            <form id="formEditarDispositivo" method="POST" action="{{  route('actualizar', $dispositivo) }}" >
                @csrf <!-- Token CSRF para seguridad -->
                @method('PUT') <!-- Define el método HTTP como PUT para actualizar -->

                <!-- Campo de texto: nombre del dispositivo -->
                <input type="text" id="txtNombreEditar" name="NombreDispositivo" placeholder="Nombre" maxlength="30" value="{{ $dispositivo->NombreDispositivo }}" required>

                <!-- Campo de texto: marca del dispositivo -->
                <input type="text" id="txtMarcaEditar" name="Marca" placeholder="Marca" maxlength="30" value="{{ $dispositivo->Marca }}" required>

                <!-- Campo de texto: modelo del dispositivo -->
                <input type="text" id="txtModeloEditar" name="Modelo" placeholder="Modelo" maxlength="100" value="{{ $dispositivo->Modelo }}" required>

                <!-- Campo de tipo de dispositivo (solo lectura / no editable) -->
                <select id="TipoDropDownEditar" name="IdTipoDispositivo" class="form-control" disabled>
                    <option value="{{ $dispositivo->tipoDispositivo->IdTipoDispositivo }}">
                        {{ $dispositivo->tipoDispositivo->Tipo }}
                    </option>
                </select>

                <!-- Sección visible si el dispositivo es una PC, laptop o celular -->
                @if($dispositivo->pclapcel)
                    <div id="panelPcLapCelEditar" class="panel">
                        <input type="number" id="txtMemoriaEditar" name="Memoria" placeholder="Memoria (GB)" min="1" max="5000" value="{{ $dispositivo->pclapcel->Memoria }}" required>
                        <input type="text" id="txtTipoMemoriaEditar" name="TipoMemoria" placeholder="Tipo de memoria" maxlength="30" value="{{ $dispositivo->pclapcel->TipoMemoria }}" required>
                        <input type="number" id="txtRAMEditar" name="Ram" placeholder="RAM (GB)" min="1" max="100" value="{{ $dispositivo->pclapcel->Ram }}" required>
                        <input type="text" id="txtProcesadorEditar" name="Procesador" placeholder="Procesador" maxlength="30" value="{{ $dispositivo->pclapcel->Procesador }}" required>
                        <input type="text" id="txtSOEditar" name="SistemaOperativo" placeholder="Sistema Operativo" maxlength="30" value="{{ $dispositivo->pclapcel->SistemaOperativo }}" required>
                    </div>
                @endif

                <!-- Sección visible si el dispositivo es una pantalla -->
                @if($dispositivo->pantalla)
                    <div id="panelPantallaEditar" class="panel">
                        <input type="number" id="txtPulgadasEditar" name="Pulgadas" placeholder="Pulgadas" min="1" value="{{ $dispositivo->pantalla->Pulgadas }}" required>
                    </div>
                @endif

                <!-- Selector de estado actual del dispositivo -->
                <select id="EstadoDropDownEditar" name="IdEstado" required>
                    <option value="">Seleccione estado</option>
                    @foreach($estados as $estado)
                        <option value="{{ $estado->IdEstado }}"
                            @if($dispositivo->IdEstado == $estado->IdEstado) selected @endif>
                            {{ $estado->Descripcion }}
                        </option>
                    @endforeach
                </select>

                <!-- Selector del área asignada -->
                <select id="AreaDropDownEditar" name="IdArea" required>
                    <option value="">Seleccione área</option>
                    @foreach($areas as $area)
                        <option value="{{ $area->IdArea }}"
                            @if($dispositivo->IdArea == $area->IdArea) selected @endif>
                            {{ $area->NombreArea }}
                        </option>
                    @endforeach
                </select>

                <!-- Selector de sucursal asignada -->
                <select id="SucursalDropDownEditar" name="IdSucursal" required>
                    <option value="">Seleccione sucursal</option>
                    @foreach($sucursales as $sucursal)
                        <option value="{{ $sucursal->IdSucursal }}"
                            @if($dispositivo->IdSucursal == $sucursal->IdSucursal) selected @endif>
                            {{ $sucursal->NombreSucursal }}
                        </option>
                    @endforeach
                </select>

                <!-- Botones de acción: guardar o cancelar -->
                <button type="submit" id="btnGuardarEditar" class="btn btn-primary">Guardar Cambios</button>
                <button type="button" id="btnCancelarEditar" class="btn btn-secondary">Cancelar</button>

                <!-- Script para redirigir al inventario si se cancela la edición -->
                <script>
                    document.getElementById('btnCancelarEditar').addEventListener('click', function () {
                        window.location.href = "{{ route('mostrarinventario') }}";
                    });
                </script>
            </form>
        </div>
    </div>

    <!-- Script de lógica para esta vista (por ejemplo, manejo dinámico del formulario) -->
    <script src="{{ asset('Scripts/Inventario.js') }}" defer></script>
</body>
</html>
