<!DOCTYPE html>
<html lang="es">
<head>
    <!-- Configuración básica del documento HTML -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>

    <!-- Vinculo al archivo de estilos para esta vista -->
    <link rel="stylesheet" href="{{ asset('Estilos/actualizar-agregar.css') }}" />
</head>
<body>
    <!-- Modal/panel para agregar un nuevo dispositivo -->
    <div id="panelAgregarDispositivo" class="container-agregar">
        <h3 class="title-caja">Agregando dispositivo</h3>

        <div class="box">
            <!-- Formulario para enviar los datos del nuevo dispositivo -->
            <form id="formAgregarDispositivo" action="{{ route('agregar') }}" method="POST">
                @csrf <!-- Token CSRF para protección contra ataques de falsificación -->

                {{-- Inputs principales --}}
                <!-- Selección del tipo de dispositivo -->
                <select id="TipoSelect" class="form-control" name="Tipo" required>
                    <option value="">Seleccione tipo</option>
                    @foreach ($tiposDispositivo as $tipo)
                        <!-- Opción por cada tipo disponible en la base de datos -->
                        <option value="{{ $tipo->IdTipoDispositivo }}">
                            {{ $tipo->Tipo }}
                        </option>
                    @endforeach
                </select>

                <!-- Inputs de texto para datos generales del dispositivo -->
                <input type="text" class="form-control" placeholder="Nombre" name="NombreDispositivo" maxlength="30" required/>
                <input type="text" class="form-control" placeholder="Marca" name="Marca" maxlength="30" required/>
                <input type="text" class="form-control" placeholder="Modelo" name="Modelo" maxlength="100" required/>

                <!-- Select para el estado del dispositivo -->
                <select class="form-control" name="IdEstado" required>
                    <option value="">Seleccione estado</option>
                    @foreach ($estados as $estado)
                        <option value="{{ $estado->IdEstado }}">{{ $estado->Descripcion }}</option>
                    @endforeach
                </select>

                <!-- Select para el área en la que se asigna el dispositivo -->
                <select class="form-control" name="IdArea" required>
                    <option value="">Seleccione área</option>
                    @foreach ($areas as $area)
                        <option value="{{ $area->IdArea }}">{{ $area->NombreArea }}</option>
                    @endforeach
                </select>

                <!-- Select para la sucursal correspondiente -->
                <select class="form-control" name="IdSucursal" required>
                    <option value="">Seleccione sucursal</option>
                    @foreach ($sucursales as $sucursal)
                        <option value="{{ $sucursal->IdSucursal }}">{{ $sucursal->NombreSucursal }}</option>
                    @endforeach
                </select>

                <!-- Sección para campos específicos de PC/Laptop/Celular -->
                <div id="panelPcLapCel" style="display:none;">
                    <input type="number" class="form-control" placeholder="Almacenamiento (GB)" name="Memoria" min="1" max="5000" required/>
                    <input type="text" class="form-control" placeholder="Tipo de Almacenamiento" name="TipoMemoria" maxlength="30" required/>
                    <input type="number" class="form-control" min="1" placeholder="RAM (GB)" name="Ram" max="100" required/>
                    <input type="text" class="form-control" placeholder="Procesador" name="Procesador" maxlength="30" required/>
                    <input type="text" class="form-control" placeholder="Sistema Operativo" name="SistemaOperativo" maxlength="30" required/>
                </div>

                <!-- Sección para campos específicos de pantallas -->
                <div id="panelPantalla" style="display:none;">
                    <input type="number" class="form-control" placeholder="Pulgadas" name="Pulgadas" min="1" max="100" required/>
                </div>

                {{-- Botones para guardar o cancelar --}}
                <div class="box">
                    <!-- Botón para guardar el formulario -->
                    <button type="submit" class="btn btn-primary">Guardar</button>

                    <!-- Botón para cancelar y redirigir al inventario -->
                    <button type="button" class="btn btn-secondary" id="btnCancelar">Cancelar</button>
                </div>
            </form>

            {{-- Script para manejar la acción del botón cancelar --}}
            <script>
                document.getElementById('btnCancelar').addEventListener('click', function () {
                    // Redirecciona a la vista principal del inventario
                    window.location.href = "{{ route('mostrarinventario') }}";
                });
            </script>
        </div>
    </div>

    <!-- Script con lógica adicional para mostrar u ocultar campos según el tipo -->
    <script src="{{ asset('Scripts/Agregar.js') }}"></script>
</body>
</html>
