<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Inventario Sistemas</title>

    <!-- Enlace al archivo CSS personalizado para estilos del inventario -->
    <link rel="stylesheet" href="{{ asset('Estilos/Inventario.css') }}" />

    <!-- Preconexión para optimizar carga de fuentes desde Google -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" />

    <!-- Fuente Inconsolata de Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inconsolata:wght@200..900&display=swap" rel="stylesheet" />

    <!-- Iconos de FontAwesome (version 6.4.0) para botones de acción -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
</head>

<body class="body1">
    <div id="contenidoPrincipal">
        <header>
            <!-- Formulario para búsqueda y filtrado de dispositivos -->
            <form action="{{ route('buscar') }}" method="GET" class="hd">
                <div class="menu">
                    <!-- Icono de menú tipo hamburguesa -->
                    <svg id="lines" xmlns="http://www.w3.org/2000/svg" width="40" height="36" fill="currentColor" class="bi bi-list" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5" />
                    </svg>
                </div>

                <!-- Filtros de búsqueda: nombre, tipo, área, sucursal, estado -->
                <div class="selects">
                    <!-- Campo para buscar por nombre del dispositivo -->
                    <input type="text" id="busqueda" name="busqueda" placeholder="Nombre dispositivo" class="form-control" value="{{ request('busqueda') }}" />

                    <!-- Filtro por tipo de dispositivo -->
                    <select id="tipo_dispositivo" name="tipo" class="form-control">
                        <option value="" {{ request('tipo') == '' ? 'selected' : '' }}>Tipo de dispositivo</option>
                        @foreach($tiposDispositivo as $tipo)
                            <option value="{{$tipo->IdTipoDispositivo}}" {{ request('tipo') == $tipo->IdTipoDispositivo ? 'selected' : '' }}>{{$tipo->Tipo}}</option>
                        @endforeach
                    </select>

                    <!-- Filtro por área -->
                    <select id="area" name="area" class="form-control">
                        <option value="" {{ request('area') == '' ? 'selected' : '' }}>Área</option>
                        @foreach ($areas as $area)
                            <option value="{{$area->IdArea}}" {{ request('area') == $area->IdArea ? 'selected' : '' }}>{{$area->NombreArea}}</option>
                        @endforeach
                    </select>

                    <!-- Filtro por sucursal -->
                    <select id="sucursales" name="sucursales" class="form-control">
                        <option value="" {{ request('sucursales') == '' ? 'selected' : '' }}>Sucursal</option>
                        @foreach ($sucursales as $sucursal)
                            <option value="{{$sucursal->IdSucursal}}" {{ request('sucursales') == $sucursal->IdSucursal ? 'selected' : '' }}>{{$sucursal->NombreSucursal}}</option>
                        @endforeach
                    </select>

                    <!-- Filtro por estado del dispositivo -->
                    <select id="Estado" name="estado" class="form-control">
                        <option value="" {{ request('estado') == '' ? 'selected' : '' }}>Estado</option>
                        @foreach ($estados as $estado)
                            <option value="{{$estado->IdEstado}}" {{ request('estado') == $estado->IdEstado ? 'selected' : '' }}>{{$estado->Descripcion}}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Botones de acción para buscar y limpiar filtros -->
                <div class="buttons">
                    <button id="btn_buscar" type="submit" class="btn btn-primary">Buscar</button>

                    <!-- Botón para limpiar filtros, redirige a la vista sin filtros -->
                    <button id="btn_limpiarFiltros" type="button" class="btn btn-secondary" data-url="{{ route('mostrarinventario') }}">Limpiar</button>
                </div>
            </form>
        </header>

        <!-- Mensaje de éxito en operaciones (mostrar por 3 segundos) -->
        <div class="container mt-3">
            @if(session('success'))
                <div id="mensajeExito" class="alert alert-success alert-dismissible fade show">
                    {{ session('success') }}
                </div>

                <script>
                    setTimeout(function() {
                        var mensaje = document.getElementById('mensajeExito');
                        if (mensaje) {
                            mensaje.style.display = 'none';
                        }
                    }, 3000);
                </script>
            @endif

            <!-- Mensaje de error (también se oculta tras 3 segundos) -->
            @if(session('error'))
                <div id="mensajeError" class="alert alert-danger alert-dismissible fade show">
                    {{ session('error') }}
                </div>

                <script>
                    setTimeout(function() {
                        var mensaje = document.getElementById('mensajeError');
                        if (mensaje) {
                            mensaje.style.display = 'none';
                        }
                    }, 3000);
                </script>
            @endif
        </div>

        <main class="principal">
            <!-- Menú lateral oculto por defecto -->
            <aside class="aside-hidden">
                <div class="user">
                    <!-- Icono de usuario -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="currentColor" class="bi bi-person-circle" viewBox="0 0 16 16">
                        <path d="M11 6a3 3 0 1 1-6 0 3 3 0 0 1 6 0" />
                        <path fill-rule="evenodd" d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m8-7a7 7 0 0 0-5.468 11.37C3.242 11.226 4.805 10 8 10s4.757 1.225 5.468 2.37A7 7 0 0 0 8 1" />                    </svg>
                </div>

                <!-- Texto de bienvenida al usuario autenticado -->
                <p id="bienvenida">
                    Bienvenido/a: {{Auth::guard('admin')->user()->Nombre}}
                </p>

                <!-- Botón para ir a la vista de agregar un nuevo dispositivo -->
                <button type="button" id="btnAbrirModalAgregar" class="btn btn-success salto-linea">
                    Agregar<br>Dispositivo
                </button>

                <script>
                    // Redirección al presionar el botón de agregar
                    document.getElementById('btnAbrirModalAgregar').addEventListener('click', function(){
                        window.location.href = "{{ route('vistaAgregar') }}";
                    });
                </script>

                <!-- Enlace para cerrar sesión -->
                <a href="" id="btnCerrarSesion" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <!-- Icono de salir -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-box-arrow-left" viewBox="0 0 16 16" style="color:white">
                        <path fill-rule="evenodd" d="M6 12.5a.5.5 0 0 0 .5.5h8a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 0-.5-.5h-8a.5.5 0 0 0-.5.5v2a.5.5 0 0 1-1 0v-2A1.5 1.5 0 0 1 6.5 2h8A1.5 1.5 0 0 1 16 3.5v9a1.5 1.5 0 0 1-1.5 1.5h-8A1.5 1.5 0 0 1 5 12.5v-2a.5.5 0 0 1 1 0z" />
                        <path fill-rule="evenodd" d="M.146 8.354a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L1.707 7.5H10.5a.5.5 0 0 1 0 1H1.707l2.147 2.146a.5.5 0 0 1-.708.708z" />
                    </svg>
                </a>

                <!-- Formulario oculto para cerrar sesión (usado por el enlace anterior) -->
                <form id="logout-form" action="{{ route('admin.logout') }}" method="POST" style="display: none;">
                    @csrf
                </form>
            </aside>

            <!-- Contenedor principal de la tabla de dispositivos -->
            <div class="contenido-tabla">
                <table id="Dispositivos" class="mi-tabla">
                    <thead>
                        <tr>
                            <!-- Encabezados de columnas -->
                            <th>ID</th>
                            <th>Tipo</th>
                            <th>Nombre</th>
                            <th>Marca</th>
                            <th>Modelo</th>
                            <th>Memoria (GB)</th>
                            <th>Tipo Memoria</th>
                            <th>RAM</th>
                            <th>Procesador</th>
                            <th>Sistema Operativo</th>
                            <th>Pulgadas</th>
                            <th>Estado</th>
                            <th>Área</th>
                            <th>Sucursal</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>

                    <tbody>
                        <!-- Iteración sobre la lista de dispositivos para mostrar cada uno en la tabla -->
                        @foreach ($dispositivos as $dispositivo)
                        <tr>
                            <td>{{ $dispositivo->IdDispositivo }}</td>
                            <td>{{ $dispositivo->tipoDispositivo->Tipo ?? '-' }}</td>
                            <td>{{ $dispositivo->NombreDispositivo }}</td>
                            <td>{{ $dispositivo->Marca }}</td>
                            <td>{{ $dispositivo->Modelo }}</td>
                            <td>{{ $dispositivo->pclapcel->Memoria ?? '-'}}</td>
                            <td>{{ $dispositivo->pclapcel->TipoMemoria ?? '-'}}</td>
                            <td>{{ $dispositivo->pclapcel->Ram ?? '-'}}</td>
                            <td>{{ $dispositivo->pclapcel->Procesador ?? '-'}}</td>
                            <td>{{ $dispositivo->pclapcel->SistemaOperativo ?? '-'}}</td>
                            <td>{{ $dispositivo->pantalla->Pulgadas ?? '-'}}</td>
                            <td>{{ $dispositivo->estado->Descripcion ?? '-'}}</td>
                            <td>{{ $dispositivo->area->NombreArea ?? '-'}}</td>
                            <td>{{ $dispositivo->sucursal->NombreSucursal ?? '-'}}</td>
                            <td>
                                <!-- Botón para editar dispositivo -->
                                <a href="{{route('vistaActualizar', $dispositivo)}}" id="btnEditar" class="icono-accion actualizarbtn" title="Editar">
                                    <i class="fas fa-pen-to-square" style="color:#bfa100;  margin-bottom:5px;"></i>
                                </a>

                                <!-- Formulario para eliminar dispositivo -->
                                <form action="{{route('eliminar', $dispositivo->IdDispositivo)}}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="icono-accion" title="Eliminar" onclick="return confirm('¿Seguro que deseas eliminar este dispositivo?')">
                                        <i class="fas fa-trash" style="color:red ;"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach 
                    </tbody>
                </table>
            </div>
        </main>
    </div>

    <!-- Script personalizado para funcionalidades JS en el inventario -->
    <script src="{{ asset('Scripts/Inventario.js') }}"></script>
</body>
</html>
