<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Inventario Sistemas</title>

    <!-- Enlace al archivo CSS personalizado para estilos del inventario -->
    <link rel="stylesheet" href="{{ asset('Estilos/Inventario.css') }}" />

    <!-- Preconexión para optimizar carga de fuentes desde Google -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" />

    <!-- Fuente Inconsolata de Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inconsolata:wght@200..900&display=swap" rel="stylesheet" />

    <!-- Iconos de FontAwesome (version 6.4.0) para botones de acción -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
</head>

<body class="body1">
    <div id="contenidoPrincipal">
        <header>
            <!-- Formulario para búsqueda y filtrado de dispositivos -->
            <form action="{{ route('buscar') }}" method="GET" class="hd">
                <div class="menu">
                    <!-- Icono de menú tipo hamburguesa -->
                    <svg id="lines" xmlns="http://www.w3.org/2000/svg" width="40" height="36" fill="currentColor" class="bi bi-list" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5" />
                    </svg>
                </div>

                <!-- Filtros de búsqueda: nombre, tipo, área, sucursal, estado -->
                <div class="selects">
                    <!-- Campo para buscar por nombre del dispositivo -->
                    <input type="text" id="busqueda" name="busqueda" placeholder="Nombre dispositivo" class="form-control" value="{{ request('busqueda') }}" />

                    <!-- Filtro por tipo de dispositivo -->
                    <select id="tipo_dispositivo" name="tipo" class="form-control">
                        <option value="" {{ request('tipo') == '' ? 'selected' : '' }}>Tipo de dispositivo</option>
                        @foreach($tiposDispositivo as $tipo)
                            <option value="{{$tipo->IdTipoDispositivo}}" {{ request('tipo') == $tipo->IdTipoDispositivo ? 'selected' : '' }}>{{$tipo->Tipo}}</option>
                        @endforeach
                    </select>

                    <!-- Filtro por área -->
                    <select id="area" name="area" class="form-control">
                        <option value="" {{ request('area') == '' ? 'selected' : '' }}>Área</option>
                        @foreach ($areas as $area)
                            <option value="{{$area->IdArea}}" {{ request('area') == $area->IdArea ? 'selected' : '' }}>{{$area->NombreArea}}</option>
                        @endforeach
                    </select>

                    <!-- Filtro por sucursal -->
                    <select id="sucursales" name="sucursales" class="form-control">
                        <option value="" {{ request('sucursales') == '' ? 'selected' : '' }}>Sucursal</option>
                        @foreach ($sucursales as $sucursal)
                            <option value="{{$sucursal->IdSucursal}}" {{ request('sucursales') == $sucursal->IdSucursal ? 'selected' : '' }}>{{$sucursal->NombreSucursal}}</option>
                        @endforeach
                    </select>

                    <!-- Filtro por estado del dispositivo -->
                    <select id="Estado" name="estado" class="form-control">
                        <option value="" {{ request('estado') == '' ? 'selected' : '' }}>Estado</option>
                        @foreach ($estados as $estado)
                            <option value="{{$estado->IdEstado}}" {{ request('estado') == $estado->IdEstado ? 'selected' : '' }}>{{$estado->Descripcion}}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Botones de acción para buscar y limpiar filtros -->
                <div class="buttons">
                    <button id="btn_buscar" type="submit" class="btn btn-primary">Buscar</button>

                    <!-- Botón para limpiar filtros, redirige a la vista sin filtros -->
                    <button id="btn_limpiarFiltros" type="button" class="btn btn-secondary" data-url="{{ route('mostrarinventariovista') }}">Limpiar</button>
                </div>
            </form>
        </header>

        <!-- Mensaje de éxito en operaciones (mostrar por 3 segundos) -->
        <div class="container mt-3">
            @if(session('success'))
                <div id="mensajeExito" class="alert alert-success alert-dismissible fade show">
                    {{ session('success') }}
                </div>

                <script>
                    setTimeout(function() {
                        var mensaje = document.getElementById('mensajeExito');
                        if (mensaje) {
                            mensaje.style.display = 'none';
                        }
                    }, 3000);
                </script>
            @endif

            <!-- Mensaje de error (también se oculta tras 3 segundos) -->
            @if(session('error'))
                <div id="mensajeError" class="alert alert-danger alert-dismissible fade show">
                    {{ session('error') }}
                </div>

                <script>
                    setTimeout(function() {
                        var mensaje = document.getElementById('mensajeError');
                        if (mensaje) {
                            mensaje.style.display = 'none';
                        }
                    }, 3000);
                </script>
            @endif
        </div>

        <main class="principal">
            

            <!-- Contenedor principal de la tabla de dispositivos -->
            <div class="contenido-tabla">
                <table id="Dispositivos" class="mi-tabla">
                    <thead>
                        <tr>
                            <!-- Encabezados de columnas -->
                            <th>ID</th>
                            <th>Tipo</th>
                            <th>Nombre</th>
                            <th>Marca</th>
                            <th>Modelo</th>
                            <th>Memoria (GB)</th>
                            <th>Tipo Memoria</th>
                            <th>RAM</th>
                            <th>Procesador</th>
                            <th>Sistema Operativo</th>
                            <th>Pulgadas</th>
                            <th>Estado</th>
                            <th>Área</th>
                            <th>Sucursal</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>

                    <tbody>
                        <!-- Iteración sobre la lista de dispositivos para mostrar cada uno en la tabla -->
                        @foreach ($dispositivos as $dispositivo)
                        <tr>
                            <td>{{ $dispositivo->IdDispositivo }}</td>
                            <td>{{ $dispositivo->tipoDispositivo->Tipo ?? '-' }}</td>
                            <td>{{ $dispositivo->NombreDispositivo }}</td>
                            <td>{{ $dispositivo->Marca }}</td>
                            <td>{{ $dispositivo->Modelo }}</td>
                            <td>{{ $dispositivo->pclapcel->Memoria ?? '-'}}</td>
                            <td>{{ $dispositivo->pclapcel->TipoMemoria ?? '-'}}</td>
                            <td>{{ $dispositivo->pclapcel->Ram ?? '-'}}</td>
                            <td>{{ $dispositivo->pclapcel->Procesador ?? '-'}}</td>
                            <td>{{ $dispositivo->pclapcel->SistemaOperativo ?? '-'}}</td>
                            <td>{{ $dispositivo->pantalla->Pulgadas ?? '-'}}</td>
                            <td>{{ $dispositivo->estado->Descripcion ?? '-'}}</td>
                            <td>{{ $dispositivo->area->NombreArea ?? '-'}}</td>
                            <td>{{ $dispositivo->sucursal->NombreSucursal ?? '-'}}</td>
                            <td>
                                
                            </td>
                        </tr>
                        @endforeach 
                    </tbody>
                </table>
            </div>
        </main>
    </div>

    <!-- Script personalizado para funcionalidades JS en el inventario -->
    <script src="{{ asset('Scripts/Inventario.js') }}"></script>
</body>
</html>
