<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Login Linfolab</title>

    <!-- Token CSRF para proteger contra ataques Cross-Site Request Forgery -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Enlace al archivo de estilos personalizado para el login -->
    <link rel="stylesheet" href="{{ asset('Estilos/login.css') }}" />

    <!-- Preconexión para optimizar la carga de fuentes de Google -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />

    <!-- Fuente Roboto Condensed importada desde Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Condensed:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet" />
</head>
<body>
    <!-- Formulario de login con método POST que envía datos a la ruta 'login.form' -->
    <form id="form1" method="POST" action="{{ route('login.form') }}">
        @csrf <!-- Directiva Blade que inserta un token CSRF oculto para protección de seguridad -->
        
        <div class="contenedor-principal">
            <h3>Inventario Sistemas</h3>

            <!-- Imagen del logo cargada desde la carpeta 'Imagenes' usando la función asset() -->
            <img id="logo" src="{{ asset('Imagenes/logo.png') }}" alt="Logo" />

            <!-- Campo de entrada para el correo electrónico del usuario -->
            <label for="txtCorreo">Correo</label>
            <input
                type="email"
                id="txtCorreo"
                name="email"
                class="input-text"
                placeholder="Escriba su correo"
                required />

            <!-- Campo de entrada para la contraseña del usuario -->
            <label for="txtContraseña">Contraseña</label>
            <input
                type="password"
                id="txtContraseña"
                name="password"
                class="input-text"
                placeholder="Ingrese su contraseña"
                required />

            <!-- Botón para enviar el formulario de inicio de sesión -->
            <button
                type="submit"
                id="btnIngresar"
                class="btn-submit">
                Ingresar
            </button>

            <br />

            <!-- Si hay errores de validación, se muestra el primer mensaje de error en rojo -->
            @if($errors->any())
                <div id="lblMensaje" style="color: red;">
                    {{ $errors->first() }}
                </div>
            @endif
        </div>
    </form>
</body>
</html>
