<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\InventarioController;
use App\Http\Controllers\InventarioVistaController;

// Ruta para mostrar la vista de login (página de inicio para autenticarse)
Route::get('/', function () {
    return view('login'); 
})->name('login'); // Nombre de ruta para referenciar login fácilmente

// Ruta para procesar el formulario de login (POST)
Route::post('/admin/login', [LoginController::class, 'login'])->name('login.form');
Route::get('/inventariovista', [InventarioVistaController::class, 'mostrarinventariovista'])->name('mostrarinventariovista');
    // Ruta para realizar búsquedas y filtros en el inventario
    //Route::get('/inventariovista', [InventarioVistaController::class, 'mostrarinventariovista'])->name('mostrarinventariovista');

// Grupo de rutas protegidas por middleware 'auth:admin' (requiere estar autenticado como administrador)
Route::group(['middleware' => ['auth:admin']], function() {
    // Mostrar el inventario con dispositivos (vista principal después de login)
    Route::get('/inventario', [InventarioController::class, 'mostrarinventario'])->name('mostrarinventario');

    // Ruta para cerrar sesión del administrador (logout)
    Route::post('/admin/logout', [LoginController::class, 'logout'])->name('admin.logout');

    // Mostrar formulario para agregar un nuevo dispositivo
    Route::get('/agregar', [InventarioController::class, 'MostrarVistaAgregar'])->name('vistaAgregar');

    // Procesar el formulario para agregar un nuevo dispositivo (POST)
    Route::post('/agregar', [InventarioController::class, 'agregar'])->name('agregar');

    // Mostrar formulario para actualizar dispositivo existente
    Route::get('/actualizar/{id}', [InventarioController::class, 'MostrarVistaActualizar'])->name('vistaActualizar');

    // Procesar formulario para actualizar dispositivo (PUT)
    Route::put('/actualizar/{id}', [InventarioController::class, 'actualizar'])->name('actualizar');

    // Eliminar un dispositivo específico por ID (DELETE)
    Route::delete('/EliminarRegistro/{id}', [InventarioController::class, 'EliminarRegistro'])->name('eliminar');

    // Ruta para realizar búsquedas y filtros en el inventario
    //Route::get('/buscar', [InventarioController::class, 'buscar'])->name('buscar');
     
});    





    
     

