<!DOCTYPE html>
<html lang="es">
<head>
    <!-- Configuración general de la página -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Login Linfolab</title>

    <!-- CSRF Token para protección en Laravel -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Enlace a hoja de estilos CSS externa -->
    <link rel="stylesheet" href="<?php echo e(asset('Estilos/login.css')); ?>" />

    <!-- Carga de fuentes desde Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Condensed:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet" />
</head>
<body>
    <!-- Formulario HTML estándar adaptado para Laravel -->
    <form id="form1" method="POST" action="<?php echo e(route('login.form')); ?>">
        <?php echo csrf_field(); ?> <!-- Directiva de Laravel para protección CSRF -->
        
        <div class="contenedor-principal">
            <!-- Título de la página -->
            <h3>Inventario Sistemas</h3>

            <!-- Imagen del logo -->
            <img id="logo" src="<?php echo e(asset('Imagenes/logo.png')); ?>" alt="Logo" />

            <!-- Campo de entrada para el correo -->
            <label for="txtCorreo">Correo</label>
            <input
                type="email"
                id="txtCorreo"
                name="email"
                class="input-text"
                placeholder="Escriba su correo"
                required />

            <!-- Campo de entrada para la contraseña -->
            <label for="txtContraseña">Contraseña</label>
            <input
                type="password"
                id="txtContraseña"
                name="password"
                class="input-text"
                placeholder="Ingrese su contraseña"
                required />

            <!-- Botón para enviar el formulario -->
            <button
                type="submit"
                id="btnIngresar"
                class="btn-submit">
                Ingresar
            </button>

            <br />

            <!-- Etiqueta para mostrar mensajes de error o validación -->
            <?php if($errors->any()): ?>
                <div id="lblMensaje" style="color: red;">
                    <?php echo e($errors->first()); ?>

                </div>
            <?php endif; ?>
        </div>
    </form>
</body>
</html><?php /**PATH C:\Users\1\Videos\InventarioSistemas\resources\views\login.blade.php ENDPATH**/ ?>