<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Inventario Sistemas</title>

    <!-- Enlace al archivo CSS personalizado para estilos del inventario -->
    <link rel="stylesheet" href="<?php echo e(asset('Estilos/Inventario.css')); ?>" />

    <!-- Preconexión para optimizar carga de fuentes desde Google -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" />

    <!-- Fuente Inconsolata de Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inconsolata:wght@200..900&display=swap" rel="stylesheet" />

    <!-- Iconos de FontAwesome (version 6.4.0) para botones de acción -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
</head>

<body class="body1">
    <div id="contenidoPrincipal">
        <header>
            <!-- Formulario para búsqueda y filtrado de dispositivos -->
            <form action="<?php echo e(route('buscar')); ?>" method="GET" class="hd">
                <div class="menu">
                    <!-- Icono de menú tipo hamburguesa -->
                    <svg id="lines" xmlns="http://www.w3.org/2000/svg" width="40" height="36" fill="currentColor" class="bi bi-list" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5" />
                    </svg>
                </div>

                <!-- Filtros de búsqueda: nombre, tipo, área, sucursal, estado -->
                <div class="selects">
                    <!-- Campo para buscar por nombre del dispositivo -->
                    <input type="text" id="busqueda" name="busqueda" placeholder="Nombre dispositivo" class="form-control" value="<?php echo e(request('busqueda')); ?>" />

                    <!-- Filtro por tipo de dispositivo -->
                    <select id="tipo_dispositivo" name="tipo" class="form-control">
                        <option value="" <?php echo e(request('tipo') == '' ? 'selected' : ''); ?>>Tipo de dispositivo</option>
                        <?php $__currentLoopData = $tiposDispositivo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($tipo->IdTipoDispositivo); ?>" <?php echo e(request('tipo') == $tipo->IdTipoDispositivo ? 'selected' : ''); ?>><?php echo e($tipo->Tipo); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <!-- Filtro por área -->
                    <select id="area" name="area" class="form-control">
                        <option value="" <?php echo e(request('area') == '' ? 'selected' : ''); ?>>Área</option>
                        <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($area->IdArea); ?>" <?php echo e(request('area') == $area->IdArea ? 'selected' : ''); ?>><?php echo e($area->NombreArea); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <!-- Filtro por sucursal -->
                    <select id="sucursales" name="sucursales" class="form-control">
                        <option value="" <?php echo e(request('sucursales') == '' ? 'selected' : ''); ?>>Sucursal</option>
                        <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($sucursal->IdSucursal); ?>" <?php echo e(request('sucursales') == $sucursal->IdSucursal ? 'selected' : ''); ?>><?php echo e($sucursal->NombreSucursal); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <!-- Filtro por estado del dispositivo -->
                    <select id="Estado" name="estado" class="form-control">
                        <option value="" <?php echo e(request('estado') == '' ? 'selected' : ''); ?>>Estado</option>
                        <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($estado->IdEstado); ?>" <?php echo e(request('estado') == $estado->IdEstado ? 'selected' : ''); ?>><?php echo e($estado->Descripcion); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Botones de acción para buscar y limpiar filtros -->
                <div class="buttons">
                    <button id="btn_buscar" type="submit" class="btn btn-primary">Buscar</button>

                    <!-- Botón para limpiar filtros, redirige a la vista sin filtros -->
                    <button id="btn_limpiarFiltros" type="button" class="btn btn-secondary" data-url="<?php echo e(route('mostrarinventario')); ?>">Limpiar</button>
                </div>
            </form>
        </header>

        <!-- Mensaje de éxito en operaciones (mostrar por 3 segundos) -->
        <div class="container mt-3">
            <?php if(session('success')): ?>
                <div id="mensajeExito" class="alert alert-success alert-dismissible fade show">
                    <?php echo e(session('success')); ?>

                </div>

                <script>
                    setTimeout(function() {
                        var mensaje = document.getElementById('mensajeExito');
                        if (mensaje) {
                            mensaje.style.display = 'none';
                        }
                    }, 3000);
                </script>
            <?php endif; ?>

            <!-- Mensaje de error (también se oculta tras 3 segundos) -->
            <?php if(session('error')): ?>
                <div id="mensajeError" class="alert alert-danger alert-dismissible fade show">
                    <?php echo e(session('error')); ?>

                </div>

                <script>
                    setTimeout(function() {
                        var mensaje = document.getElementById('mensajeError');
                        if (mensaje) {
                            mensaje.style.display = 'none';
                        }
                    }, 3000);
                </script>
            <?php endif; ?>
        </div>

        <main class="principal">
            <!-- Menú lateral oculto por defecto -->
            <aside class="aside-hidden">
                <div class="user">
                    <!-- Icono de usuario -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="currentColor" class="bi bi-person-circle" viewBox="0 0 16 16">
                        <path d="M11 6a3 3 0 1 1-6 0 3 3 0 0 1 6 0" />
                        <path fill-rule="evenodd" d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m8-7a7 7 0 0 0-5.468 11.37C3.242 11.226 4.805 10 8 10s4.757 1.225 5.468 2.37A7 7 0 0 0 8 1" />                    </svg>
                </div>

                <!-- Texto de bienvenida al usuario autenticado -->
                <p id="bienvenida">
                    Bienvenido/a: <?php echo e(Auth::guard('admin')->user()->Nombre); ?>

                </p>

                <!-- Botón para ir a la vista de agregar un nuevo dispositivo -->
                <button type="button" id="btnAbrirModalAgregar" class="btn btn-success salto-linea">
                    Agregar<br>Dispositivo
                </button>

                <script>
                    // Redirección al presionar el botón de agregar
                    document.getElementById('btnAbrirModalAgregar').addEventListener('click', function(){
                        window.location.href = "<?php echo e(route('vistaAgregar')); ?>";
                    });
                </script>

                <!-- Enlace para cerrar sesión -->
                <a href="" id="btnCerrarSesion" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <!-- Icono de salir -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-box-arrow-left" viewBox="0 0 16 16" style="color:white">
                        <path fill-rule="evenodd" d="M6 12.5a.5.5 0 0 0 .5.5h8a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 0-.5-.5h-8a.5.5 0 0 0-.5.5v2a.5.5 0 0 1-1 0v-2A1.5 1.5 0 0 1 6.5 2h8A1.5 1.5 0 0 1 16 3.5v9a1.5 1.5 0 0 1-1.5 1.5h-8A1.5 1.5 0 0 1 5 12.5v-2a.5.5 0 0 1 1 0z" />
                        <path fill-rule="evenodd" d="M.146 8.354a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L1.707 7.5H10.5a.5.5 0 0 1 0 1H1.707l2.147 2.146a.5.5 0 0 1-.708.708z" />
                    </svg>
                </a>

                <!-- Formulario oculto para cerrar sesión (usado por el enlace anterior) -->
                <form id="logout-form" action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: none;">
                    <?php echo csrf_field(); ?>
                </form>
            </aside>

            <!-- Contenedor principal de la tabla de dispositivos -->
            <div class="contenido-tabla">
                <table id="Dispositivos" class="mi-tabla">
                    <thead>
                        <tr>
                            <!-- Encabezados de columnas -->
                            <th>ID</th>
                            <th>Tipo</th>
                            <th>Nombre</th>
                            <th>Marca</th>
                            <th>Modelo</th>
                            <th>Memoria (GB)</th>
                            <th>Tipo Memoria</th>
                            <th>RAM</th>
                            <th>Procesador</th>
                            <th>Sistema Operativo</th>
                            <th>Pulgadas</th>
                            <th>Estado</th>
                            <th>Área</th>
                            <th>Sucursal</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>

                    <tbody>
                        <!-- Iteración sobre la lista de dispositivos para mostrar cada uno en la tabla -->
                        <?php $__currentLoopData = $dispositivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dispositivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($dispositivo->IdDispositivo); ?></td>
                            <td><?php echo e($dispositivo->tipoDispositivo->Tipo ?? '-'); ?></td>
                            <td><?php echo e($dispositivo->NombreDispositivo); ?></td>
                            <td><?php echo e($dispositivo->Marca); ?></td>
                            <td><?php echo e($dispositivo->Modelo); ?></td>
                            <td><?php echo e($dispositivo->pclapcel->Memoria ?? '-'); ?></td>
                            <td><?php echo e($dispositivo->pclapcel->TipoMemoria ?? '-'); ?></td>
                            <td><?php echo e($dispositivo->pclapcel->Ram ?? '-'); ?></td>
                            <td><?php echo e($dispositivo->pclapcel->Procesador ?? '-'); ?></td>
                            <td><?php echo e($dispositivo->pclapcel->SistemaOperativo ?? '-'); ?></td>
                            <td><?php echo e($dispositivo->pantalla->Pulgadas ?? '-'); ?></td>
                            <td><?php echo e($dispositivo->estado->Descripcion ?? '-'); ?></td>
                            <td><?php echo e($dispositivo->area->NombreArea ?? '-'); ?></td>
                            <td><?php echo e($dispositivo->sucursal->NombreSucursal ?? '-'); ?></td>
                            <td>
                                <!-- Botón para editar dispositivo -->
                                <a href="<?php echo e(route('vistaActualizar', $dispositivo)); ?>" id="btnEditar" class="icono-accion actualizarbtn" title="Editar">
                                    <i class="fas fa-pen-to-square" style="color:#bfa100;  margin-bottom:5px;"></i>
                                </a>

                                <!-- Formulario para eliminar dispositivo -->
                                <form action="<?php echo e(route('eliminar', $dispositivo->IdDispositivo)); ?>" method="POST" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="icono-accion" title="Eliminar" onclick="return confirm('¿Seguro que deseas eliminar este dispositivo?')">
                                        <i class="fas fa-trash" style="color:red ;"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                    </tbody>
                </table>
            </div>
        </main>
    </div>

    <!-- Script personalizado para funcionalidades JS en el inventario -->
    <script src="<?php echo e(asset('Scripts/Inventario.js')); ?>"></script>
</body>
</html>
<?php /**PATH /home/linfolab/public_html/sistemas.grupolinfolab.mx/resources/views/inventario.blade.php ENDPATH**/ ?>