<!DOCTYPE html>
<html lang="es">
<head>
    <!-- Configuración básica del documento HTML -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>

    <!-- Vinculo al archivo de estilos para esta vista -->
    <link rel="stylesheet" href="<?php echo e(asset('Estilos/actualizar-agregar.css')); ?>" />
</head>
<body>
    <!-- Modal/panel para agregar un nuevo dispositivo -->
    <div id="panelAgregarDispositivo" class="container-agregar">
        <h3 class="title-caja">Agregando dispositivo</h3>

        <div class="box">
            <!-- Formulario para enviar los datos del nuevo dispositivo -->
            <form id="formAgregarDispositivo" action="<?php echo e(route('agregar')); ?>" method="POST">
                <?php echo csrf_field(); ?> <!-- Token CSRF para protección contra ataques de falsificación -->

                
                <!-- Selección del tipo de dispositivo -->
                <select id="TipoSelect" class="form-control" name="Tipo" required>
                    <option value="">Seleccione tipo</option>
                    <?php $__currentLoopData = $tiposDispositivo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!-- Opción por cada tipo disponible en la base de datos -->
                        <option value="<?php echo e($tipo->IdTipoDispositivo); ?>">
                            <?php echo e($tipo->Tipo); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <!-- Inputs de texto para datos generales del dispositivo -->
                <input type="text" class="form-control" placeholder="Nombre" name="NombreDispositivo" maxlength="30" required/>
                <input type="text" class="form-control" placeholder="Marca" name="Marca" maxlength="30" required/>
                <input type="text" class="form-control" placeholder="Modelo" name="Modelo" maxlength="100" required/>

                <!-- Select para el estado del dispositivo -->
                <select class="form-control" name="IdEstado" required>
                    <option value="">Seleccione estado</option>
                    <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($estado->IdEstado); ?>"><?php echo e($estado->Descripcion); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <!-- Select para el área en la que se asigna el dispositivo -->
                <select class="form-control" name="IdArea" required>
                    <option value="">Seleccione área</option>
                    <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($area->IdArea); ?>"><?php echo e($area->NombreArea); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <!-- Select para la sucursal correspondiente -->
                <select class="form-control" name="IdSucursal" required>
                    <option value="">Seleccione sucursal</option>
                    <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($sucursal->IdSucursal); ?>"><?php echo e($sucursal->NombreSucursal); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <!-- Sección para campos específicos de PC/Laptop/Celular -->
                <div id="panelPcLapCel" style="display:none;">
                    <input type="number" class="form-control" placeholder="Almacenamiento (GB)" name="Memoria" min="1" max="5000" required/>
                    <input type="text" class="form-control" placeholder="Tipo de Almacenamiento" name="TipoMemoria" maxlength="30" required/>
                    <input type="number" class="form-control" min="1" placeholder="RAM (GB)" name="Ram" max="100" required/>
                    <input type="text" class="form-control" placeholder="Procesador" name="Procesador" maxlength="30" required/>
                    <input type="text" class="form-control" placeholder="Sistema Operativo" name="SistemaOperativo" maxlength="30" required/>
                </div>

                <!-- Sección para campos específicos de pantallas -->
                <div id="panelPantalla" style="display:none;">
                    <input type="number" class="form-control" placeholder="Pulgadas" name="Pulgadas" min="1" max="100" required/>
                </div>

                
                <div class="box">
                    <!-- Botón para guardar el formulario -->
                    <button type="submit" class="btn btn-primary">Guardar</button>

                    <!-- Botón para cancelar y redirigir al inventario -->
                    <button type="button" class="btn btn-secondary" id="btnCancelar">Cancelar</button>
                </div>
            </form>

            
            <script>
                document.getElementById('btnCancelar').addEventListener('click', function () {
                    // Redirecciona a la vista principal del inventario
                    window.location.href = "<?php echo e(route('mostrarinventario')); ?>";
                });
            </script>
        </div>
    </div>

    <!-- Script con lógica adicional para mostrar u ocultar campos según el tipo -->
    <script src="<?php echo e(asset('Scripts/Agregar.js')); ?>"></script>
</body>
</html>
<?php /**PATH /home/linfolab/public_html/sistemas.grupolinfolab.mx/resources/views/agregar.blade.php ENDPATH**/ ?>