<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="<?php echo e(asset('Estilos/actualizar-agregar.css')); ?>" />
    <title>Document</title>
</head>
<body> 
        <!-- Modal para editar dispositivo (añade esto al final de tu inventario.blade.php) -->
    <div id="panelEditarDispositivo" Class="container-actualizar">
        <h3 class="title-caja">Actualizando dispositivo</h3>
        <div class="box">
            <!-- Formulario para editar (usaremos Laravel Collective o HTML estándar) -->
            <form id="formEditarDispositivo" method="POST" action="<?php echo e(route('actualizar', $dispositivo)); ?>" >
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <!-- Campos del dispositivo -->
                <input type="text" id="txtNombreEditar" name="NombreDispositivo" placeholder="Nombre" maxlength="30" value="<?php echo e($dispositivo->NombreDispositivo); ?>" required>
                <input type="text" id="txtMarcaEditar" name="Marca" placeholder="Marca" maxlength="30" value="<?php echo e($dispositivo->Marca); ?>" required>
                <input type="text" id="txtModeloEditar" name="Modelo" placeholder="Modelo" maxlength="100" value = "<?php echo e($dispositivo->Modelo); ?>"required>

                <!-- Dropdown Tipo (deshabilitado) -->
                <select id="TipoDropDownEditar" name="IdTipoDispositivo" class="form-control" disabled>
                    <option value="<?php echo e($dispositivo->tipoDispositivo->IdTipoDispositivo); ?>"><?php echo e($dispositivo->tipoDispositivo->Tipo); ?></option>
                </select>

                <!-- Panel dinámico para PC/Laptop/Celular (inicialmente oculto) -->
                <?php if($dispositivo->pclapcel): ?>
                    <div id="panelPcLapCelEditar" class="panel">
                        <input type="number" id="txtMemoriaEditar" name="Memoria" placeholder="Memoria (GB)" min="1" max="5000" value = "<?php echo e($dispositivo->pclapcel->Memoria); ?>" required>
                        <input type="text" id="txtTipoMemoriaEditar" name="TipoMemoria" placeholder="Tipo de memoria" maxlength="30" value = "<?php echo e($dispositivo->pclapcel->TipoMemoria); ?>" required>
                        <input type="number" id="txtRAMEditar" name="Ram" placeholder="RAM (GB)" min="1" max= "100" value = "<?php echo e($dispositivo->pclapcel->Ram); ?>" value = "<?php echo e($dispositivo->pclapcel->Ram); ?>" required>
                        <input type="text" id="txtProcesadorEditar" name="Procesador" placeholder="Procesador" maxlength="30" value = "<?php echo e($dispositivo->pclapcel->Procesador); ?>" required>
                        <input type="text" id="txtSOEditar" name="SistemaOperativo" placeholder="Sistema Operativo" maxlength="30" value = "<?php echo e($dispositivo->pclapcel->SistemaOperativo); ?>" required>
                    </div>
                <?php endif; ?>

                <!-- Panel para Pantalla (inicialmente oculto) -->
                <?php if($dispositivo->pantalla): ?>
                    <div id="panelPantallaEditar" class="panel">
                        <input type="number" id="txtPulgadasEditar" name="Pulgadas" placeholder="Pulgadas" min="1" value = "<?php echo e($dispositivo->pantalla->Pulgadas); ?>"required>
                    </div>
                <?php endif; ?>
                
                <!-- Dropdowns para Estado, Área y Sucursal -->
                <select id="EstadoDropDownEditar" name="IdEstado" required>
                    <option value="">Seleccione estado</option>
                    <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($estado->IdEstado); ?>"
                            <?php if($dispositivo->IdEstado == $estado->IdEstado): ?> selected <?php endif; ?>>
                            <?php echo e($estado->Descripcion); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>


                <select id="AreaDropDownEditar" name="IdArea" required>
                    <option value="">Seleccione área</option>
                    <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($area->IdArea); ?>" 
                            <?php if($dispositivo->IdArea == $area->IdArea): ?> selected <?php endif; ?>>
                            <?php echo e($area->NombreArea); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <select id="SucursalDropDownEditar" name="IdSucursal" required>
                    <option value="">Seleccione sucursal</option>
                    <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($sucursal->IdSucursal); ?>"
                            <?php if($dispositivo->IdSucursal == $sucursal->IdSucursal): ?> selected <?php endif; ?>>
                            <?php echo e($sucursal->NombreSucursal); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <!-- Botones -->
                <button type="submit" id="btnGuardarEditar" class="btn btn-primary">Guardar Cambios</button>
                <button type="button" id="btnCancelarEditar" class="btn btn-secondary" >Cancelar</button>

                <script>
                    document.getElementById('btnCancelarEditar').addEventListener('click', function () {
                        window.location.href = "<?php echo e(route('mostrarinventario')); ?>";
                    });
                </script>
            </form>
        </div>
    </div>
    <script src="<?php echo e(asset('Scripts/Inventario.js')); ?>" defer></script>
</body>
</html><?php /**PATH C:\Users\1\Videos\InventarioSistemas\resources\views\actualizar.blade.php ENDPATH**/ ?>