<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="<?php echo e(asset('Estilos/actualizar-agregar.css')); ?>" />
</head>
<body>
    <!--  -->
    <div id="panelAgregarDispositivo" class="container-agregar">
        <h3 class="title-caja">Agregando dispositivo</h3>
        <div class="box">
            <form id="formAgregarDispositivo" action="<?php echo e(route('agregar')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                
                <select id="TipoSelect" class="form-control" name="Tipo" required>
                    <option value="">Seleccione tipo</option>
                    <?php $__currentLoopData = $tiposDispositivo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($tipo->IdTipoDispositivo); ?>">
                            <?php echo e($tipo->Tipo); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <input type="text" class="form-control" placeholder="Nombre" name="NombreDispositivo" maxlength = "30" required/>
                <input type="text" class="form-control" placeholder="Marca" name="Marca" maxlength = "30" required/>
                <input type="text" class="form-control" placeholder="Modelo" name="Modelo" maxlength = "100" required />

                <select class="form-control" name="IdEstado" required>
                    <option value="">Seleccione estado</option>
                    <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($estado->IdEstado); ?>"><?php echo e($estado->Descripcion); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <select class="form-control" name="IdArea" required>
                    <option value="">Seleccione área</option>
                    <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($area->IdArea); ?>"><?php echo e($area->NombreArea); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <select class="form-control" name="IdSucursal" required>
                    <option value="">Seleccione sucursal</option>
                    <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($sucursal->IdSucursal); ?>"><?php echo e($sucursal->NombreSucursal); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>

                <div id="panelPcLapCel" style="display:none;">
                    <input type="number" class="form-control" placeholder="Almacenamiento (GB)" name="Memoria" min = "1" max="5000" required/>
                    <input type="text" class="form-control" placeholder="Tipo de Almacenamiento" name="TipoMemoria" maxlength= "30" required/>
                    <input type="number" class="form-control" min="1" placeholder="RAM (GB)" name="Ram" min = "1" max = "100" required/>
                    <input type="text" class="form-control" placeholder="Procesador" name="Procesador"  maxlength= "30" required/>
                    <input type="text" class="form-control" placeholder="Sistema Operativo" name="SistemaOperativo"  maxlength= "30" required/>
                </div>

                <div id="panelPantalla" style="display:none;">
                    <input type="number" class="form-control"  placeholder="Pulgadas" name="Pulgadas" min = "1" max = "100" required/>
                </div>

                
                <div class="box">
                    <button type="submit" class="btn btn-primary">Guardar</button>
                    <button type="button" class="btn btn-secondary" id="btnCancelar">Cancelar</button>
                </div>
            </form>

            
            <script>
                document.getElementById('btnCancelar').addEventListener('click', function () {
                    window.location.href = "<?php echo e(route('mostrarinventario')); ?>";
                });
            </script>
        </div>
    </div>
    <script src="<?php echo e(asset('Scripts/Agregar.js')); ?>"></script>
</body>
</html><?php /**PATH C:\Users\1\Videos\InventarioSistemas\resources\views\agregar.blade.php ENDPATH**/ ?>